
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:saxon="http://icl.com/saxon" 
  xmlns="http://www.w3.org/1999/xhtml"
  xmlns:svg="http://www.w3.org/2000/svg"
  xmlns:h="http://www.w3.org/1999/xhtml"
  exclude-result-prefixes="h svg"
  extension-element-prefixes="saxon"
  
>

<xsl:output method="text" encoding="iso-8859-1"/>

<xsl:template match="h:talk">
 <xsl:apply-templates select="h:body"/>
</xsl:template>

<xsl:variable name="base" select="/h:talk/@base"/>

<xsl:template match="h:body">
<saxon:output method="xml" indent="no"
href="{$base}-{format-number(position(),'00')}.xml">
<xsl:text>&#10;</xsl:text>
<xsl:processing-instruction name="xml-stylesheet"
>type="text/xsl" href="<xsl:choose>
<xsl:when test=".//svg:svg">svg.xsl</xsl:when>
<xsl:otherwise>mathml.xsl</xsl:otherwise>
</xsl:choose>"</xsl:processing-instruction>
<html>
<head>
<title><xsl:value-of select="h:h1"/></title>
<script>
function newdoc(s) {
document.location.href=(s.options[s.options.selectedIndex].value);
}
</script>
<link rel="stylesheet" type="text/css" href="mmlxsl.css"/>
</head>
<body>
<span class="toc">
<xsl:choose>
<xsl:when test="position()=1">
 <span class="grey">previous</span>
</xsl:when>
<xsl:otherwise>
<a href="{$base}-{format-number(position()-1,'00')}.xml">previous</a>
</xsl:otherwise>
</xsl:choose>
&#160;
<xsl:variable name="x" select="position()"/>
<select name="toc" onchange="newdoc(this)">
<xsl:for-each select="../h:body/h:h1">
<option
value="{$base}-{format-number(position(),'00')}.xml">
 <xsl:if test="position()=$x">
 <xsl:attribute name="selected">selected</xsl:attribute>
 </xsl:if>
  <xsl:value-of select="concat(format-number(position(),'00'),': ',.)"/>
</option>
</xsl:for-each>
</select>
&#160;
<xsl:choose>
<xsl:when test="@next">
  <a href="{$base}-{format-number(count(../h:body[h:h1=current()/@next]/preceding-sibling::h:body)+1,'00')}.xml">next</a>
</xsl:when>
<xsl:when test="position()=last()">
 <span class="grey">next</span>
</xsl:when>
<xsl:otherwise>
<a href="{$base}-{format-number(position()+1,'00')}.xml">next</a>
</xsl:otherwise>
</xsl:choose>
</span>
<xsl:copy-of select="node()"/>
</body>
</html>
</saxon:output>

</xsl:template> 


</xsl:stylesheet>
