<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">


<xsl:import href="slices.xsl"/>
<xsl:output method="html"
       encoding="ISO-8859-1"
       doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
       doctype-system="http://www.w3.org/TR/html4/loose.dtd"
       indent="no"/>

<xsl:param name="toc.level" select="3"/>

<!-- Extensions and parameterisation of xmlspec 
     These templates produce the same output as the standard xmlspec
     templates (and could be incorporated into later versions of
     xmlspec.xsl) but include extra parameterisation possibilities.
-->

<!-- for parameters, xmlspec defaults are commented out, mmlspec choices
are used, if these parameters were in xmlspec/slices, then only these
parameters would be needed here and the templates wouldnt need to be
copied -->


<!--
<xsl:param name="body.filename.base" select="'slice'"/>
<xsl:param name="back.filename.base" select="'slice'"/>
<xsl:param name="back.filename.format" select="'A'"/>
<xsl:param name="front.filename.base" select="'index'"/>
<xsl:param name="filename.extension" select="'.html'"/>


<xsl:param name="slice.depth" select="0"/>

<xsl:param name="title.before.navigation" select="0"/>

<xsl:param name="css.base.uri" select="'http://www.w3.org/StyleSheets/TR/'"/>
-->
<xsl:param name="body.filename.base" select="'chapter'"/>
<xsl:param name="back.filename.base" select="'appendix'"/>
<xsl:param name="back.filename.format" select="'a'"/>
<xsl:param name="front.filename.base" select="'overview'"/>
<xsl:param name="filename.extension" select="'.html'"/>
<xsl:param name="validity.hacks" select="0"/><!--!!!!!!-->

<xsl:param name="slice.depth" select="1"/>

<xsl:param name="title.before.navigation" select="1"/>

<xsl:param name="css.base.uri" select="'http://www.w3.org/StyleSheets/TR/'"/>

<!-- FILENAMES -->

<xsl:template match="body/div1" mode="slice-filename">
  <xsl:variable name="docnumber">
    <xsl:number count="div1" level="multiple" format="1"/>
  </xsl:variable>
  <xsl:value-of select="$body.filename.base"/>
  <xsl:value-of select="$docnumber"/>
  <xsl:value-of select="$filename.extension"/>
</xsl:template>

<xsl:template match="back/div1 | inform-div1" mode="slice-filename">
  <xsl:variable name="docnumber">
    <xsl:number count="div1|inform-div1" level="multiple" format="{$back.filename.format}"/>
  </xsl:variable>
  <xsl:value-of select="$back.filename.base"/>
  <xsl:value-of select="$docnumber"/>
  <xsl:value-of select="$filename.extension"/>
</xsl:template>



<xsl:template match="spec" mode="slice-filename">
  <xsl:value-of select="$front.filename.base"/>
  <xsl:value-of select="$filename.extension"/>
</xsl:template>


<!-- mmlspec customisation later 

<xsl:template name="navigation.top">
  <xsl:param name="prev" select="''"/>
  <xsl:param name="next" select="''"/>

  <a name="Top"/>
  <xsl:comment> TOP NAVIGATION BAR </xsl:comment>
  <table border="0" width="90%"
         cellpadding="4" cellspacing="0"
         bgcolor="#eeeeff"
         class="navigation"
summary="Navigation Bar">
    <col width="25%"/>
    <col width="25%"/>
    <col width="25%"/>
    <col width="25%"/>
    <tr>
      <td>&#xa0;</td>
      <td>&#xa0;</td>
      <td>&#xa0;</td>
      <td>&#xa0;</td>
    </tr>
    <tr>
      <td align="left">
        <a href="{$front.filename.base}{$filename.extension}#contents">Table of Contents</a>
      </td>
      <td align="left">
        <xsl:choose>
          <xsl:when test="$prev">
            <a>
              <xsl:attribute name="href">
                <xsl:call-template name="href.target">
                  <xsl:with-param name="target" select="$prev"/>
                  <xsl:with-param name="just.filename" select="1"/>
                </xsl:call-template>
              </xsl:attribute>
              <xsl:text>Prev</xsl:text>
            </a>
          </xsl:when>
          <xsl:otherwise>&#160;</xsl:otherwise>
        </xsl:choose>
      </td>
      <td align="left">
        <xsl:choose>
          <xsl:when test="$next">
            <a>
              <xsl:attribute name="href">
                <xsl:call-template name="href.target">
                  <xsl:with-param name="target" select="$next"/>
                  <xsl:with-param name="just.filename" select="1"/>
                </xsl:call-template>
              </xsl:attribute>
              <xsl:text>Next</xsl:text>
            </a>
          </xsl:when>
          <xsl:otherwise>&#160;</xsl:otherwise>
        </xsl:choose>
      </td>
      <td align="left">
        <a href="#Bottom">Bottom</a>
      </td>
    </tr>
  </table>

  !- - quick table of contents - ->
  <table border="0" width="90%"
         cellpadding="4" cellspacing="0" 
         bgcolor="#eeeeff"
         class="navigation-toc"
summary="Navigation TOC"
>
    <col width="100%"/>
    <tr align="left"><th><hr/>Quick Table of Contents<hr/></th></tr>
    <tr>
      <td>
        <xsl:apply-templates mode="toc" select=".">
          <xsl:with-param name="just.filename" select="'0'"/>
        </xsl:apply-templates>
      </td>
    </tr>
  </table>
</xsl:template>

-->

<!-- END OF FILENAMES -->



<!-- HTML HEADING DEPTH -->

  <xsl:template match="example/head">
    <xsl:text>&#10;</xsl:text>
    <xsl:choose>
      <xsl:when test="$tabular.examples = 0">
        <div class="exampleHead">
          <xsl:text>Example: </xsl:text>
          <xsl:apply-templates/>
        </div>
      </xsl:when>
      <xsl:otherwise>
    <xsl:variable name="depth"  select="count(ancestor::*[contains(name(),'div')])"/>
    <xsl:variable name="h">
     <xsl:choose>
      <xsl:when test="$depth &gt; $slice.depth">
        <xsl:value-of select="1 + $depth  - $slice.depth"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="1 + $depth"/>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:variable>
        <xsl:element name="h{$h+1}">
          <xsl:call-template name="anchor">
            <xsl:with-param name="node" select=".."/>
            <xsl:with-param name="conditional" select="0"/>
          </xsl:call-template>

          <xsl:text>Example: </xsl:text>
          <xsl:apply-templates/>
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="*[contains(name(),'div')]/head">
    <xsl:text>&#10;</xsl:text>
    <xsl:variable name="depth"
    select="count(ancestor::*[contains(name(),'div')])"/>
    <xsl:variable name="num">
      <xsl:apply-templates select=".." mode="divnum"/>
    </xsl:variable>
    <xsl:variable name="h">
     <xsl:choose>
      <xsl:when test="$depth &gt; $slice.depth">
        <xsl:value-of select="1+ $depth  - $slice.depth"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="1"/>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:variable>
    <xsl:element name="h{$h}">
      <xsl:call-template name="anchor">
        <xsl:with-param name="conditional" select="0"/>
        <xsl:with-param name="node" select=".."/>
        <xsl:with-param name="default.id" select="translate(concat('id.',$num),' ','')"/>
      </xsl:call-template>
      <xsl:copy-of select="$num"/>
      <xsl:apply-templates/>
      <xsl:if test="parent::inform-div1"> (Non-Normative)</xsl:if>
    </xsl:element>
  </xsl:template>


<!-- Combined toc template for all the div elements.
     This has toc.level as a _local_ parameter rather than global
     so main document toc and per-chapter tocs can be different
     depths.
-->
  <xsl:template match="*[contains(name(),'div')]|MMLdefinition" mode="toc">
    <xsl:param name="indent" select="''"/>
    <xsl:param name="toc.level" select="$toc.level"/>
    <xsl:variable name="depth"
    select="count(ancestor::*[contains(name(),'div')])"/>
    <xsl:variable name="num">
      <xsl:apply-templates select="." mode="divnum"/>
    </xsl:variable>
    <xsl:value-of select="$indent"/>
    <xsl:copy-of select="$num"/>
    <a>
      <xsl:attribute name="href">
        <xsl:call-template name="href.target">
          <xsl:with-param name="target" select="."/>
          <xsl:with-param name="default.id"  select="translate(concat('id.',$num),' ','')"/>
        </xsl:call-template>
      </xsl:attribute>
      <xsl:apply-templates select="head|name" mode="text"/>
      <xsl:if test="self::inform-div1"> (Non-Normative)</xsl:if>
    </a>
    <br/>
    <xsl:if test="$depth +1 &lt; $toc.level">
      <xsl:apply-templates select="*[contains(name(),'div')]|MMLdefinition" mode="toc">
       <xsl:with-param name="indent" select="concat($indent,'&#160;&#160;&#160;&#160;')"/>
       <xsl:with-param name="toc.level" select="$toc.level"/>
      </xsl:apply-templates>
    </xsl:if>
  </xsl:template>


<!-- END OF HTML HEADING DEPTH -->


<!-- OBJECT ID -->
<!-- use @id in preference to default.id and use this to generate 
     references as well as anchors so as to get #id.1.2 rather than
     #lscdkalc
-->
<xsl:template name="object.id">
  <xsl:param name="node" select="."/>
  <xsl:param name="default.id" select="''"/>

  <xsl:choose>
    <xsl:when test="$node/@id">
      <xsl:value-of select="translate($node/@id,'_','.')"/>
    </xsl:when>
    <!-- can't use the default ID if it's used somewhere else in the document! -->
    <xsl:when test="$default.id != '' and not(key('ids', $default.id))">
      <xsl:value-of select="$default.id"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="generate-id($node)"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- END OF OBJECT ID -->


<!-- QUICK TOC LOCATION -->

<xsl:template match="body/div1">
  <xsl:variable name="prev"
                select="(preceding::div1|preceding::inform-div1)[last()]"/>
  <xsl:variable name="next"
                select="(following::div1|following::inform-div1)[1]"/>

  <xsl:call-template name="write.chunk">
    <xsl:with-param name="filename">
      <xsl:apply-templates select="." mode="slice-filename"/>
    </xsl:with-param>
    <xsl:with-param name="content">
      <html>
      <xsl:if test="header/langusage/language">
        <xsl:attribute name="lang">
          <xsl:value-of select="header/langusage/language/@id"/>
        </xsl:attribute>
      </xsl:if>
       <head>
          <title><xsl:value-of select="head"/></title>
          <xsl:call-template name="css"/>
        </head>
        <body>
          <xsl:apply-templates select="head[$title.before.navigation]"/>
          <xsl:call-template name="navigation.top">
            <xsl:with-param name="prev" select="$prev"/>
            <xsl:with-param name="next" select="$next"/>
          </xsl:call-template>

          <div class="div1">
            <xsl:apply-templates select="node()[not(self::head[$title.before.navigation])]"/>
          </div>

          <xsl:call-template name="navigation.bottom">
            <xsl:with-param name="prev" select="$prev"/>
            <xsl:with-param name="next" select="$next"/>
          </xsl:call-template>
        </body>
      </html>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="back/div1 | back/inform-div1">
  <xsl:variable name="prev"
                select="(preceding::div1|preceding::inform-div1)[last()]"/>
  <xsl:variable name="next"
                select="(following::div1|following::inform-div1)[1]"/>

  <xsl:call-template name="write.chunk">
    <xsl:with-param name="filename">
      <xsl:apply-templates select="." mode="slice-filename"/>
    </xsl:with-param>
    <xsl:with-param name="content">
      <html>
        <head>
          <title><xsl:value-of select="head"/></title>
          <xsl:call-template name="css"/>
        </head>
        <body>
          <xsl:apply-templates select="head[$title.before.navigation]"/>
          <xsl:call-template name="navigation.top">
            <xsl:with-param name="prev" select="$prev"/>
            <xsl:with-param name="next" select="$next"/>
          </xsl:call-template>

          <div class="div1">
            <xsl:apply-templates select="node()[not(self::head[$title.before.navigation])]"/>
          </div>

          <xsl:call-template name="navigation.bottom">
            <xsl:with-param name="prev" select="$prev"/>
            <xsl:with-param name="next" select="$next"/>
          </xsl:call-template>
        </body>
      </html>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="inform-div1">
  <xsl:variable name="prev"
                select="(preceding::div1|preceding::inform-div1)[last()]"/>
  <xsl:variable name="next"
                select="(following::div1|following::inform-div1)[1]"/>

  <xsl:call-template name="write.chunk">
    <xsl:with-param name="filename">
      <xsl:apply-templates select="." mode="slice-filename"/>
    </xsl:with-param>
    <xsl:with-param name="content">
      <html>
        <head>
          <title><xsl:value-of select="head"/></title>
          <xsl:call-template name="css"/>
        </head>
        <body>
          <xsl:apply-templates select="head[$title.before.navigation]"/>
          <xsl:call-template name="navigation.top">
            <xsl:with-param name="prev" select="$prev"/>
            <xsl:with-param name="next" select="$next"/>
          </xsl:call-template>

          <div class="div1">
            <xsl:apply-templates select="node()[not(self::head[$title.before.navigation])]"/>
          </div>

          <xsl:call-template name="navigation.bottom">
            <xsl:with-param name="prev" select="$prev"/>
            <xsl:with-param name="next" select="$next"/>
          </xsl:call-template>
        </body>
      </html>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!-- END OF QUICK TOC LOCATION -->







<!-- SLIST -->
 <xsl:template match="slist">
    <ul>
        <xsl:apply-templates/>
    </ul>
  </xsl:template>

<xsl:template match="sitem">
    <li class="sitem"><xsl:apply-templates/></li>
  </xsl:template>

  <xsl:template match="item">
   <xsl:if test="$show.diff.markup='1' or not(@diff='del')">
    <li>
         <xsl:if test="@diff and $show.diff.markup='1'">
            <xsl:attribute name="class">
              <xsl:text>diff-</xsl:text>
              <xsl:value-of select="@diff"/>
            </xsl:attribute>
     </xsl:if>
      <xsl:apply-templates/>
         <xsl:if test="@diff and $show.diff.markup='1'">
        <xsl:call-template name="diff-back-link"/>
         </xsl:if>
    </li>
   </xsl:if>
  </xsl:template>

<!-- NESTED PARAGRAPHAS -->

<!-- xmlspec, like most document formats other than html, allows
    block level elements in paragraphs. For hTML need to
    separately wrap each conecutive run of inline elements in <p>
    and leave block level elements outside the p.

   xmlspec.xsl has some code using disable-output-escaping to
   attempt to do this, but it doesn't really work, evn with processors
   taht support d-o-e. The original mathml stylesheet as used for
   mathml 1.01 had code to deal with this, but this is a more
   efficient implementation using the grouping technique using keys.
-->


<xsl:key name="pnodes" match="p/node()" 
                  use="generate-id((..|
                     (preceding-sibling::*|.)[
          self::eg
       or self::glist
       or self::olist
       or self::ulist
       or self::slist
       or self::orglist
       or self::table
       or self::issue
       or self::note
       or self::processing-instruction()
       or self::graphic[not(@role='inline')]
        ])[last()])"/>

<xsl:template match="p">
<xsl:variable name="p1">
<p>
        <xsl:if test="@id">
         <xsl:attribute name="id"><xsl:value-of
  select="translate(@id,'_','.')"/></xsl:attribute>
        </xsl:if>
 <xsl:if test="@role">
   <xsl:attribute name="class">
      <xsl:value-of select="@role"/>
   </xsl:attribute>
 </xsl:if>
 <xsl:apply-templates select="key('pnodes',generate-id(.))"/>
</p>
</xsl:variable>
<xsl:if test="key('pnodes',generate-id(.))/self::* or normalize-space($p1)">
  <xsl:copy-of select="$p1"/>
</xsl:if>
<xsl:for-each select="eg|glist|olist|ulist|slist|orglist|
                       table|issue|note|processing-instruction()|
                       graphic[not(@role='inline')]">
<xsl:apply-templates select="."/>
<xsl:variable name="p" select="key('pnodes',generate-id(.))[position() &gt; 1]"/>
 <xsl:if test="$p[self::* or normalize-space(.)]">
<p>
<xsl:apply-templates select="$p"/>
</p>
</xsl:if>
</xsl:for-each>
</xsl:template>


<!-- END OF NESTED PARAGRAPHAS -->


<!-- RHS DIFF MARKUP (del) -->
  <xsl:template mode="number" match="prod">
    <xsl:text>[</xsl:text>
    <xsl:apply-templates select="." mode="number-simple"/>
    <xsl:text>]</xsl:text>
  </xsl:template>

  <xsl:template mode="number-simple" match="prod">
    <xsl:number level="any" count="prod[not(@diff='del' or ../@diff='del')]"/>
  </xsl:template>

  <xsl:template mode="number" match="prod[@diff='del'or ../@diff='del']">
    <xsl:text>[</xsl:text>
    <xsl:apply-templates select="preceding::prod[not(@diff='del' or ../@diff='del')][1]"
      mode="number-simple"/>
<!--
  Once again, this could be done right here, but XT won't hear of it.
    <xsl:number level="any" count="prod[not(@diff='del' or ../@diff='del')]"/>
  -->
    <xsl:number level="any" count="prod[@diff='del' or ../@diff='del']"
      from="prod[not(@diff= 'del' or ../@diff='del')]" format="a"/>
    <xsl:text>]</xsl:text>
  </xsl:template>


  <xsl:template match="prod">
    <tbody>
      <xsl:apply-templates
        select="lhs[not(@diff='del' and $show.diff.markup='0')][not(@diff='del' and $show.diff.markup='0')] |
                rhs[not(@diff='del' and $show.diff.markup='0')][preceding-sibling::*[not(@diff='del' and $show.diff.markup='0')][1][name()!='lhs']] |
                com[not(@diff='del' and $show.diff.markup='0')][preceding-sibling::*[not(@diff='del' and $show.diff.markup='0')][1][name()!='rhs']] |
                constraint[not(@diff='del' and $show.diff.markup='0')][preceding-sibling::*[not(@diff='del' and $show.diff.markup='0')][1][name()!='rhs']] |
                vc[not(@diff='del' and $show.diff.markup='0')][preceding-sibling::*[not(@diff='del' and $show.diff.markup='0')][1][name()!='rhs']] |
                wfc[preceding-sibling::*[1][name()!='rhs']]"/>
    </tbody>
  </xsl:template>

  <xsl:template match="lhs">
    <tr valign="baseline">
      <td>
        <xsl:if test="ancestor-or-self::*/@diff and $show.diff.markup='1'">
          <xsl:attribute name="class">
            <xsl:text>diff-</xsl:text>
            <xsl:value-of select="ancestor-or-self::*/@diff"/>
          </xsl:attribute>
        </xsl:if>
        <xsl:if test="../@id">
          <a name="{../@id}" id="{../@id}"/>
        </xsl:if>
        <xsl:apply-templates select="ancestor::prod" mode="number"/>
<!--
  This could be done right here, but XT goes into deep space when the
  node to be numbered isn't the current node and level="any":
          <xsl:number count="prod" level="any" from="spec"
            format="[1]"/>
  -->
        <xsl:text>&#xa0;&#xa0;&#xa0;</xsl:text>
      </td>
      <td>
        <xsl:if test="ancestor-or-self::*/@diff and $show.diff.markup='1'">
          <xsl:attribute name="class">
            <xsl:text>diff-</xsl:text>
            <xsl:value-of select="ancestor-or-self::*/@diff"/>
          </xsl:attribute>
        </xsl:if>
        <code><xsl:apply-templates/></code>
      </td>
      <td>
        <xsl:if test="ancestor-or-self::*/@diff and $show.diff.markup='1'">
          <xsl:attribute name="class">
            <xsl:text>diff-</xsl:text>
            <xsl:value-of select="ancestor-or-self::*/@diff"/>
          </xsl:attribute>
        </xsl:if>
        <xsl:text>&#xa0;&#xa0;&#xa0;::=&#xa0;&#xa0;&#xa0;</xsl:text>
      </td>
      <xsl:apply-templates
        select="following-sibling::*[not(@diff='del' and $show.diff.markup='0')][1][name()='rhs']"/>
    </tr>
  </xsl:template>


 <xsl:template match="rhs">
    <xsl:choose>
      <xsl:when test="preceding-sibling::*[not(@diff='del' and $show.diff.markup='0')][1][name()='lhs']">
        <td>
          <xsl:if test="ancestor-or-self::*/@diff and $show.diff.markup='1'">
            <xsl:attribute name="class">
              <xsl:text>diff-</xsl:text>
              <xsl:value-of select="ancestor-or-self::*[1]/@diff"/>
            </xsl:attribute>
          </xsl:if>
          <code><xsl:apply-templates/></code>
        </td>
        <xsl:apply-templates
          select="following-sibling::*[not(@diff='del' and $show.diff.markup='0')][1][name()='com' or
                                          name()='constraint' or
                                          name()='vc' or
                                          name()='wfc']"/>
      </xsl:when>
      <xsl:otherwise>
        <tr valign="baseline">
          <td/><td/><td/>
          <td>
            <xsl:if test="ancestor-or-self::*/@diff and $show.diff.markup='1'">
              <xsl:attribute name="class">
                <xsl:text>diff-</xsl:text>
                <xsl:value-of select="ancestor-or-self::*/@diff"/>
              </xsl:attribute>
            </xsl:if>
            <code><xsl:apply-templates/></code>
          </td>
          <xsl:apply-templates
            select="following-sibling::*[not(@diff='del' and $show.diff.markup='0')][1][name()='com' or
                                            name()='constraint' or
                                            name()='vc' or
                                            name()='wfc']"/>
        </tr>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
<!-- END OF RHS DIFF MARKUP (del) -->

<!-- SLICE CHECKING -->
<!--
  slices-common has
  <xsl:if test="$target != $slice">
  which repeatedly produces the string value of an entire chapter, or the entire
  spec for every internal reference. saxon produces the mathml spec in
  a third of the time on my machine  if this is changed to
  <xsl:if test="generate-id($target) != generate-id($slice)">

  In addition  add the test for "this slice" so references in chapter 3 
  to other parts of the same file are of the form #foo rather than
  chapter3.html#foo (don't do this if target = . as in that case
  you have travelled to the target first (as in toc processing).
-->

<xsl:template name="href.target">
  <xsl:param name="target" select="."/>
  <xsl:param name="default.id" select="''"/>

  <xsl:variable name="slice"
                select="($target/ancestor-or-self::div1
                        |$target/ancestor-or-self::inform-div1
                        |$target/ancestor-or-self::spec)[last()]"/>


  <xsl:variable name="thisslice"
                select="(ancestor-or-self::div1
                        |ancestor-or-self::inform-div1
                        |ancestor-or-self::spec)[last()]"/>

  <xsl:if test="(generate-id($slice) != generate-id($thisslice)) or 
                (generate-id($target) = generate-id(.))">
    <xsl:apply-templates select="$slice" mode="slice-filename"/>
  </xsl:if>
  <xsl:if test="generate-id($target) != generate-id($slice)">
    <xsl:text>#</xsl:text>
      <xsl:call-template name="object.id">
      <xsl:with-param name="node" select="$target"/>
      <xsl:with-param name="default.id" select="$default.id"/>
    </xsl:call-template>
  </xsl:if>
</xsl:template>

<!-- END OF SLICE CHECKING -->


<xsl:template match="intref">
    <xsl:variable name="target" select="key('ids', @ref)[1]"/>
        <a>
          <xsl:attribute name="href">
            <xsl:call-template name="href.target">
              <xsl:with-param name="target" select="key('ids', @ref)"/>
            </xsl:call-template>
          </xsl:attribute>
         <xsl:apply-templates/>
       </a>
</xsl:template>


<!--  Add MMLDefinition to target types and special case ref="status"
      prefix reference with Chapter Section or Appendix for div*
      targets (and make it not bold)
-->
  <!-- specref: reference to another part of the current specification -->

<xsl:template match="specref[@ref='status']">
        <a>
          <xsl:attribute name="href">
            <xsl:call-template name="href.target">
              <xsl:with-param name="target" select="key('ids', @ref)"/>
            </xsl:call-template>
          </xsl:attribute>
        <b>Status</b>
       </a>
</xsl:template>

<xsl:template match="specref[@ref='abstract']">
        <a>
          <xsl:attribute name="href">
            <xsl:call-template name="href.target">
              <xsl:with-param name="target" select="key('ids', @ref)"/>
            </xsl:call-template>
          </xsl:attribute>
        <b>Abstract</b>
       </a>
</xsl:template>

  <xsl:template match="specref">
    <xsl:variable name="target" select="key('ids', @ref)[1]"/>

    <xsl:choose>
      <xsl:when test="local-name($target)='issue'">
        <xsl:text>[</xsl:text>
        <a>
          <xsl:attribute name="href">
            <xsl:call-template name="href.target">
              <xsl:with-param name="target" select="key('ids', @ref)"/>
            </xsl:call-template>
          </xsl:attribute>
          <b>
            <xsl:text>Issue </xsl:text>
            <xsl:apply-templates select="key('ids', @ref)" mode="number"/>
            <xsl:text>: </xsl:text>
            <xsl:for-each select="key('ids', @ref)/head">
              <xsl:apply-templates/>
            </xsl:for-each>
          </b>
        </a>
        <xsl:text>]</xsl:text>
      </xsl:when>
      <xsl:when test="starts-with(local-name($target), 'div')">
        <a>
          <xsl:attribute name="href">
            <xsl:call-template name="href.target">
              <xsl:with-param name="target" select="key('ids', @ref)"/>
            </xsl:call-template>
          </xsl:attribute>
<xsl:for-each select="$target">
          <xsl:choose>
    <xsl:when test="(self::div1) and parent::body">Chapter&#160;</xsl:when>
    <xsl:when test="(self::div1 or self::inform-div1) and
      parent::back">Appendix&#160;</xsl:when>
       <xsl:otherwise>Section&#160;</xsl:otherwise>
          </xsl:choose>
</xsl:for-each>
            <xsl:apply-templates select="key('ids', @ref)" mode="divnum"/>
            <xsl:apply-templates select="key('ids', @ref)/head" mode="text"/>
        </a>
      </xsl:when>
      <xsl:when test="starts-with(local-name($target), 'inform-div')">
        <a>
          <xsl:attribute name="href">
            <xsl:call-template name="href.target">
              <xsl:with-param name="target" select="key('ids', @ref)"/>
            </xsl:call-template>
          </xsl:attribute>
             <xsl:text>Appendix&#160;</xsl:text>
            <xsl:apply-templates select="key('ids', @ref)" mode="divnum"/>
            <xsl:apply-templates select="key('ids', @ref)/head" mode="text"/>
        </a>
      </xsl:when>
      <xsl:when test="local-name($target) = 'vcnote'">
        <b>
          <xsl:text>[VC: </xsl:text>
          <a>
            <xsl:attribute name="href">
              <xsl:call-template name="href.target">
                <xsl:with-param name="target" select="key('ids', @ref)"/>
              </xsl:call-template>
            </xsl:attribute>
            <xsl:apply-templates select="key('ids', @ref)/head" mode="text"/>
          </a>
          <xsl:text>]</xsl:text>
        </b>
      </xsl:when>
      <xsl:when test="local-name($target) = 'prod'">
        <b>
          <xsl:text>[PROD: </xsl:text>
          <a>
            <xsl:attribute name="href">
              <xsl:call-template name="href.target">
                <xsl:with-param name="target" select="key('ids', @ref)"/>
              </xsl:call-template>
            </xsl:attribute>
            <xsl:apply-templates select="$target" mode="number-simple"/>
          </a>
          <xsl:text>]</xsl:text>
        </b>
      </xsl:when>
      <xsl:when test="local-name($target) = 'label'">
        <b>
          <xsl:text>[</xsl:text>
          <a>
            <xsl:attribute name="href">
              <xsl:call-template name="href.target">
                <xsl:with-param name="target" select="key('ids', @ref)"/>
              </xsl:call-template>
            </xsl:attribute>
            <xsl:value-of select="$target"/>
          </a>
          <xsl:text>]</xsl:text>
        </b>
      </xsl:when>
      <xsl:when test="local-name($target)='MMLdefinition'">
        <a>
          <xsl:attribute name="href">
            <xsl:call-template name="href.target">
              <xsl:with-param name="target" select="key('ids', @ref)"/>
            </xsl:call-template>
          </xsl:attribute>
          <b>
            <xsl:value-of select="key('ids', @ref)/name"/>
          </b>
        </a>
      </xsl:when>
      <xsl:otherwise>
        <xsl:message>
          <xsl:text>Unsupported specref to </xsl:text>
          <xsl:value-of select="local-name($target)"/>
          <xsl:text> [</xsl:text>
          <xsl:value-of select="@ref"/>
          <xsl:text>] </xsl:text>
          <xsl:text> (Contact stylesheet maintainer).</xsl:text>
        </xsl:message>
        <b>
          <a>
            <xsl:attribute name="href">
              <xsl:call-template name="href.target">
                <xsl:with-param name="target" select="key('ids', @ref)"/>
              </xsl:call-template>
            </xsl:attribute>
            <xsl:text>???</xsl:text>
          </a>
        </b>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>





 <xsl:template match="graphic">
  <xsl:choose>
    <xsl:when test="@role='inline'">
      <xsl:choose>
        <xsl:when test="@valign='bottom'">
          <img src="{@source}" alt="{@alt}" align="bottom"></img>
        </xsl:when>
        <xsl:otherwise>
          <img src="{@source}" alt="{@alt}" align="middle"></img>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    <xsl:otherwise>
      <blockquote>
      <p><img src="{@source}" alt="{@alt}"></img></p>
      </blockquote>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<!-- CSS STYLESHEET LOCATION -->
<!-- W3C publication rules insist of absolute URI to these CSS
     files. This is an annoyance to users, but is a major pain while
     developing drafts of the spec. Make the base URI for the CSS
     directory a parameter so it only needs to be
     http://www.w3.org/StyleSheets/TR/
     for the final version to be published in TR space.
-->

  <xsl:template name="css">
    <style type="text/css">
      <xsl:text>
code           { font-family: monospace; }

div.constraint,
div.issue,
div.note,
div.notice     { margin-left: 2em; }

li p           { margin-top: 0.3em;
                 margin-bottom: 0.3em; }
</xsl:text>
      <xsl:if test="$tabular.examples = 0">
        <xsl:text>
div.exampleInner pre { margin-left: 1em;
                       margin-top: 0em; margin-bottom: 0em}
div.exampleOuter {border: 4px double gray;
                  margin: 0em; padding: 0em}
div.exampleInner { background-color: #d5dee3;
                   border-top-width: 4px;
                   border-top-style: double;
                   border-top-color: #d3d3d3;
                   border-bottom-width: 4px;
                   border-bottom-style: double;
                   border-bottom-color: #d3d3d3;
                   padding: 4px; margin: 0em }
div.exampleWrapper { margin: 4px }
div.exampleHeader { font-weight: bold;
                    margin: 4px}
a.mainindex {font-weight: bold;}
li.sitem {list-style-type: none;}
</xsl:text>
      </xsl:if>
      <xsl:value-of select="$additional.css"/>
    </style>
    <link rel="stylesheet" type="text/css">
      <xsl:attribute name="href">
        <xsl:copy-of select="$css.base.uri"/>
        <xsl:choose>
          <xsl:when test="/spec/@role='editors-copy'">base</xsl:when>
          <xsl:otherwise>
            <xsl:choose>
              <xsl:when test="/spec/@w3c-doctype='wd'">W3C-WD</xsl:when>
              <xsl:when test="/spec/@w3c-doctype='rec'">W3C-REC</xsl:when>
              <xsl:when test="/spec/@w3c-doctype='pr'">W3C-PR</xsl:when>
              <xsl:when test="/spec/@w3c-doctype='per'">W3C-PER</xsl:when>
              <xsl:when test="/spec/@w3c-doctype='cr'">W3C-CR</xsl:when>
              <xsl:when test="/spec/@w3c-doctype='note'">W3C-NOTE</xsl:when>
              <xsl:otherwise>base</xsl:otherwise>
            </xsl:choose>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:text>.css</xsl:text>
      </xsl:attribute>
    </link>
  </xsl:template>

<!-- END CSS STYLESHEET LOCATION -->





<!-- local locs get multiple extensions -->
  <xsl:template match="loc">
    <a href="{@href}">
      <xsl:if test="contains(@href,'.html') and not(contains(@href,'/'))">
       <xsl:attribute name="href">
         <xsl:value-of select="substring-before(@href,'.html')"/>
         <xsl:value-of select="$filename.extension"/>
       </xsl:attribute>
      </xsl:if>
      <xsl:apply-templates/>
    </a>
   <xsl:if test="parent::prevlocs and following-sibling::loc"><br/></xsl:if>
  </xsl:template>





<!-- Templates for DOM-style interface definitions  -->
<xsl:template match="interface">
  <xsl:element name="h{5 -$slice.depth}">
  <xsl:call-template name="anchor"/>
  Interface <xsl:value-of select="@name"/>
  </xsl:element>
  <xsl:if test="normalize-space(@inherits)">
  <p><b>Extends: 
    <xsl:call-template name="dom-type-inherits">
	  <xsl:with-param name="typestring" select="@inherits"/>
    </xsl:call-template>
  </b></p>
  </xsl:if>
  <xsl:apply-templates select="descr"/>
  <xsl:if test="count(attribute) > 0">
    <p><b>Attributes</b></p>
    <dl>
      <xsl:apply-templates select="attribute"/>
    </dl>
  </xsl:if>
  <xsl:if test="count(method) > 0">
    <p><b>Methods</b></p>
    <dl>
      <xsl:apply-templates select="method"/>
    </dl>
  </xsl:if>
</xsl:template>

<xsl:template match="attribute">
   <xsl:if test="not(@diff='del' and $show.diff.markup='0')">
   <dt>
        <xsl:if test="@diff and $show.diff.markup='1'">
          <xsl:attribute name="class">
            <xsl:text>diff-</xsl:text>
            <xsl:value-of select="@diff"/>
          </xsl:attribute>
        </xsl:if>
<code class="attribute-Name"><xsl:value-of
     select="@name"/></code> of type
    <xsl:call-template name="dom-type"/>
    <xsl:if test="@readonly='yes'">
      <xsl:text>, readonly</xsl:text>
    </xsl:if>
  </dt>
  <dd><xsl:apply-templates select="descr"/>
    <xsl:apply-templates select="setraises"/>
    <xsl:apply-templates select="getraises"/>
</dd>
  </xsl:if>
</xsl:template>

<xsl:template match="descr">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="definitions">
  <xsl:apply-templates/>
</xsl:template>


<xsl:template match="exception">
   <xsl:if test="not(@diff='del' and $show.diff.markup='0')">
  <dt>
        <xsl:if test="@diff and $show.diff.markup='1'">
          <xsl:attribute name="class">
            <xsl:text>diff-</xsl:text>
            <xsl:value-of select="@diff"/>
          </xsl:attribute>
        </xsl:if>
<code><xsl:value-of select="@name"/></code></dt>
  <dd>
        <xsl:if test="@diff and $show.diff.markup='1'">
          <xsl:attribute name="class">
            <xsl:text>diff-</xsl:text>
            <xsl:value-of select="@diff"/>
          </xsl:attribute>
        </xsl:if>
<xsl:apply-templates/></dd>
</xsl:if>
</xsl:template>

<xsl:template match="method">
  <dt><code class="method-Name"><xsl:value-of
         select="@name"/></code></dt>
  <dd><xsl:apply-templates select="descr"/>
  <xsl:if test="count(parameters/param) > 0">
    <p><b>Parameters</b></p>
    <table>
      <xsl:apply-templates select="parameters/param"/>
    </table>
  </xsl:if>
  <xsl:apply-templates select="returns"/>
  <xsl:apply-templates select="raises"/>
  </dd>
</xsl:template>


<xsl:template match="param">
  <xsl:if test="not(@diff='del' and $show.diff.markup='0')">
  <tr>
        <xsl:if test="@diff and $show.diff.markup='1'">
          <xsl:attribute name="class">
            <xsl:text>diff-</xsl:text>
            <xsl:value-of select="@diff"/>
          </xsl:attribute>
        </xsl:if>
  <td class="baseline"><xsl:call-template name="dom-type"/></td>
  <td class="baseline"><code><xsl:value-of select="@name"/></code></td>
  <td class="baseline"><xsl:apply-templates select="descr"/></td>
  </tr>
</xsl:if>
</xsl:template>

<xsl:template match="returns">
  <p><b>Return value</b></p>
   <table>
   <tr>
    <td class="baseline"><xsl:call-template name="dom-type"/></td>
    <td class="baseline"><xsl:apply-templates select="descr"/></td>
  </tr>
  </table>
</xsl:template>

<xsl:template name="dom-type-inherits">
 <xsl:param name="typestring"/>
 <xsl:choose>
  <xsl:when test="contains($typestring,',')">
   <xsl:call-template name="dom-type">
    <xsl:with-param name="type" select="normalize-space(substring-before($typestring,','))"/>
   </xsl:call-template>
   <xsl:text xml:space="preserve">, </xsl:text>
   <xsl:call-template name="dom-type-inherits">
    <xsl:with-param name="typestring" select="normalize-space(substring-after($typestring,','))"/>
   </xsl:call-template>
  </xsl:when>
  <xsl:otherwise>
   <xsl:call-template name="dom-type">
    <xsl:with-param name="type" select="$typestring"/>
   </xsl:call-template>
  </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<xsl:template name="dom-type">
 <xsl:param name="type" select="@type"/>
 <code>
 <xsl:choose>
 <xsl:when test="not($type = 'void' or $type = 'long' or $type = 'unsigned long' or $type = 'short' or $type = 'unsigned short')">
 <a>
 <xsl:attribute name="href">
 <xsl:choose>
 <xsl:when test="starts-with($type, 'MathML')">
  <xsl:if test="ancestor::div1|inform-div1[not(@id='mathml-dom')]">
     <xsl:value-of select="id('mathml-dom')/@role"/>
  <xsl:value-of select="$filename.extension"/>
  </xsl:if
   >#dom.<xsl:value-of select="substring-after($type, 'MathML')"/>
 </xsl:when>
 <xsl:when test="$type = 'DOMString'"
 >http://www.w3.org/TR/DOM-Level-2-Core/core.html#DOMString</xsl:when>
<xsl:when test="$type = 'Document'"
 >http://www.w3.org/TR/DOM-Level-2-Core/core.html#i-Document</xsl:when>
 <xsl:otherwise>http://www.w3.org/TR/DOM-Level-2-Core/core.html</xsl:otherwise>
 </xsl:choose>
 </xsl:attribute>
 <xsl:value-of select="$type"/>
 </a>
 </xsl:when>
 <xsl:otherwise>
 <xsl:value-of select="$type"/>
 </xsl:otherwise>
 </xsl:choose>
 </code>
</xsl:template>

<xsl:template match="setraises">
   <xsl:choose>
   <xsl:when test="count(exception)>0">
     <p><b>Exceptions on Setting</b></p>
     <dl>
       <xsl:apply-templates select="exception"/>
     </dl>
   </xsl:when>
   </xsl:choose>
</xsl:template>

<xsl:template match="getraises">
   <xsl:choose>
   <xsl:when test="count(exception)>0">
     <p><b>Exceptions on Getting</b></p>
     <dl>
       <xsl:apply-templates select="exception"/>
     </dl>
   </xsl:when>
   </xsl:choose>
</xsl:template>

<xsl:template match="raises">
  <xsl:choose>
  <xsl:when test="count(exception) > 0">
    <p><b>Exceptions</b></p>
    <dl>
      <xsl:apply-templates select="exception"/>
    </dl>
  </xsl:when>
  <xsl:otherwise>
  <p>This method raises no exceptions.</p>
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:key name="elem" match="el[not(@namespace) or @namespace='mathml']" use="."/>
<xsl:key name="att" match="att[not(@namespace) or @namespace='mathml']" use="."/>

<xsl:template match="processing-instruction()">
  <xsl:choose>
    <xsl:when test="name(.)='generate-idl'">
      <p><b>IDL Definition</b></p>
      <div class="IDL-definition"><pre>
      <xsl:apply-templates select="ancestor::interface"           mode="idl"/>
      <xsl:apply-templates select="ancestor::interface/attribute" mode="idl"/>
      <xsl:apply-templates select="ancestor::interface/method"    mode="idl"/>
      <xsl:text>};</xsl:text>
      </pre></div>
    </xsl:when>
    <xsl:when test="name(.)='include-dtd'">
      <xsl:processing-instruction name="include">mathml.dtd.html</xsl:processing-instruction>
    </xsl:when>
    <xsl:when test="name(.)='generate-binding'">
      <xsl:choose>
        <xsl:when test="parent::div2/@id='dom-bindings_IDLBinding'">
          <xsl:apply-templates select="id('mathml-dom')" mode="IDLInterfaces"/>
        </xsl:when>
        <xsl:when test="parent::div2/@id='dom-bindings_JavaBindings'">
          <xsl:apply-templates select="id('mathml-dom')" mode="javaInterfaces"/>
        </xsl:when>
        <xsl:when test="parent::div2/@id='dom-bindings_ECMABinding'">
          <xsl:apply-templates select="id('mathml-dom')" mode="ecmaInterfaces"/>
        </xsl:when>
        <xsl:otherwise>
          <p class="error">generate-binding processing instruction for unrecognized ID 
          <xsl:value-of select="parent::div2/@id"/></p>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    <xsl:when test="name(.)='generate-domInheritance'">
      <dl>
      <xsl:apply-templates select="id('mathml-dom')//interface[not(starts-with(normalize-space(@inherits),'MathML'))]" mode="showInheritance"/> 
      </dl>
    </xsl:when>
    <xsl:when test="name(.)='generate-elements-index'">
<xsl:call-template name="index">
  <xsl:with-param name="a"
  select="//el[generate-id()=generate-id(key('elem',.))]"/>
  <xsl:with-param name="key" select="'elem'"/>
 </xsl:call-template>
    </xsl:when>
    <xsl:when test="name(.)='generate-attributes-index'">
<xsl:call-template name="index">
  <xsl:with-param name="a"
  select="//att[generate-id()=generate-id(key('att',.))]"/>
  <xsl:with-param name="key" select="'att'"/>
 </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
    <p class="error">Unrecognised processing instruction
      <xsl:value-of select="name(.)"/></p>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="index">
<xsl:param name="a"/>
<xsl:param name="key"/>
<dl>
<xsl:for-each select="$a">
<xsl:sort select="."/>
<xsl:variable name="this" select="."/>
<dt><xsl:value-of select="."/></dt>
<dd>
<xsl:for-each select="key($key,.)/ancestor::*[self::div1 or
self::div2 or self::div3 or self::div4 or self::MMLdefinition][1]">
    <xsl:variable name="num">
      <xsl:apply-templates select="." mode="divnum"/>
    </xsl:variable>
<a>
<xsl:attribute name="href">
        <xsl:call-template name="href.target">
          <xsl:with-param name="target" select="."/>
          <xsl:with-param name="default.id" select="translate(concat('id.',$num),' ','')"/>
        </xsl:call-template>
</xsl:attribute>
<xsl:if test="head/el=$this
   or  self::div4[@id='contm_trig']/p[1]/table/tbody/tr/td/el=$this
   or  ($num='3.4.7.1 ' and ($this='none' or $this='mprescripts'))">
 <xsl:attribute name="class">mainindex</xsl:attribute>
</xsl:if>
<xsl:variable name="n">
<xsl:apply-templates mode="divnum" select="."/>
</xsl:variable>
<xsl:value-of select="normalize-space($n)"/>
</a>
<xsl:if test="position() != last()"><xsl:text>, </xsl:text></xsl:if>
</xsl:for-each>
</dd>

</xsl:for-each>
</dl>
</xsl:template>


<xsl:template match="interface" mode="idl">
<xsl:text>interface </xsl:text>
  <xsl:value-of select="@name"/>
  <xsl:if test="@inherits">: <xsl:value-of select="@inherits"/></xsl:if>
  <xsl:text> {
</xsl:text>
</xsl:template>

<xsl:template match="attribute" mode="idl">
  <xsl:text xml:space="preserve">  </xsl:text>
  <xsl:if test="@readonly='yes'">
    <xsl:text>readonly </xsl:text>
  </xsl:if>
  <xsl:text>attribute </xsl:text>
  <xsl:value-of select="@type"/>
  <xsl:text xml:space="preserve"> </xsl:text>
  <xsl:value-of select="@name"/>
  <xsl:text>;
</xsl:text>
</xsl:template>

<xsl:template match="method" mode="idl">
  <xsl:text xml:space="preserve">  </xsl:text>
  <xsl:value-of select="returns/@type"/>
  <xsl:text xml:space="preserve"> </xsl:text>
  <xsl:value-of select="@name"/>
  <xsl:text>(</xsl:text>
  <xsl:apply-templates select="parameters/param" mode="idl"/>
  <xsl:text>);
</xsl:text>
</xsl:template>

<xsl:template match="param" mode="idl">
  <xsl:if test="position() > 1">
    <xsl:text>, </xsl:text>
  </xsl:if>
  <xsl:choose>
  <xsl:when test="@attr">
    <xsl:value-of select="@attr"/>
    <xsl:text xml:space="preserve"> </xsl:text>
  </xsl:when>
  <xsl:otherwise>
    <xsl:text>inout </xsl:text>
  </xsl:otherwise>
  </xsl:choose>
  <xsl:value-of select="@type"/>
  <xsl:text xml:space="preserve"> </xsl:text>
  <xsl:value-of select="@name"/>
</xsl:template>


<!-- IDL, Java, ECMAScript Bindings for DOM -->

<!-- Constant and Indentation String variables: -->

<xsl:variable name="lowerCaseString"><xsl:text>abcdefghijklmnopqrstuvwxyz</xsl:text></xsl:variable>
<xsl:variable name="upperCaseString"><xsl:text>ABCDEFGHIJKLMNOPQRSTUVWXYZ</xsl:text></xsl:variable>

<xsl:variable name="IDLindent0"><xsl:text xml:space="preserve">
</xsl:text>
</xsl:variable>

<xsl:variable name="IDLindent1"><xsl:text xml:space="preserve">
  </xsl:text>
</xsl:variable>

<xsl:variable name="IDLindent2"><xsl:text xml:space="preserve">
    </xsl:text>
</xsl:variable>

<xsl:variable name="IDLindent3"><xsl:text xml:space="preserve">
      </xsl:text>
</xsl:variable>

<xsl:variable name="IDLindent4"><xsl:text xml:space="preserve">
        </xsl:text>
</xsl:variable>

<xsl:variable name="IDLindent5"><xsl:text xml:space="preserve">
        </xsl:text>
</xsl:variable>

<xsl:variable name="raisesIndent"><xsl:text xml:space="preserve">
                                               </xsl:text>
</xsl:variable>

<xsl:variable name="javaRaisesIndent"><xsl:text xml:space="preserve">
                                                         </xsl:text>
</xsl:variable>

<xsl:variable name="javaPackageDeclaration"><xsl:text xml:space="preserve">
package org.w3c.dom.mathml;
</xsl:text>
</xsl:variable>

<xsl:variable name="idlFileHeader">
  <xsl:text xml:space="preserve">

// File: mathml-dom.idl
#ifndef _MATHMLDOM_IDL_
#define _MATHMLDOM_IDL_

#include "dom.idl"

#pragma prefix "w3c.org"

module mathml_dom
{</xsl:text>
</xsl:variable>

<xsl:variable name="idlFileFooter">
  <xsl:text xml:space="preserve">
};

#endif
</xsl:text>
</xsl:variable>  

<!-- IDL Binding -->

<xsl:template match="div1[@id='mathml-dom']" mode="IDLInterfaces">
  <div class="IDL-definition"><pre>
  <xsl:value-of select="$idlFileHeader"/>
  <xsl:apply-templates mode="IDLgetForwardDeclarations"/> 
  <xsl:value-of select="$IDLindent1"/>
  <xsl:apply-templates mode="IDLInterfaces"/>
  <xsl:value-of select="$idlFileFooter"/>
  </pre></div>
</xsl:template>

<!-- IDL GetForwardDeclarations templates -->

<xsl:template mode="IDLgetForwardDeclarations" match="interface|constant[not(ancestor::interface)]">
  <xsl:variable name="thisInterface" select="@name"/>
  <xsl:if test="count(ancestor-or-self::*[ancestor::div1[@id='mathml-dom']]/preceding-sibling::*/descendant-or-self::*[(interface[normalize-space(@inherits)=$thisInterface]) or (param|attribute|returns)[normalize-space(@type)=$thisInterface]])>0">
    <xsl:value-of select="$IDLindent1"/>
    <xsl:text xml:space="preserve">interface </xsl:text>
    <xsl:value-of select="@name"/>
    <xsl:text>;</xsl:text>
  </xsl:if>
</xsl:template>

<xsl:template mode="IDLgetForwardDeclarations" match="*">
  <xsl:apply-templates mode="IDLgetForwardDeclarations"/>
</xsl:template>

<xsl:template mode="IDLgetForwardDeclarations" match="text()">
</xsl:template>

<!-- IDLInterfaces templates -->

<xsl:template match="interface" mode="IDLInterfaces">
  <xsl:value-of select="$IDLindent1"/>
  <xsl:text xml:space="preserve">interface </xsl:text>
  <xsl:value-of select="@name"/>
  <xsl:if test="normalize-space(@inherits)">
    <xsl:text xml:space="preserve"> : </xsl:text>
    <xsl:value-of select="@inherits"/>
  </xsl:if>
  <xsl:value-of select="$IDLindent1"/>
  <xsl:text>{</xsl:text>
  <xsl:apply-templates mode="IDLInterfaces"/>
  <xsl:value-of select="$IDLindent1"/>
  <xsl:text xml:space="preserve">};
  </xsl:text>
</xsl:template>

<xsl:template match="constant" mode="IDLInterfaces">
  <xsl:value-of select="$IDLindent2"/>const <xsl:value-of select="@type"/>
  <xsl:value-of select="substring('                    ',string-length(@type)+1)"/>
  <xsl:value-of select="@name"/>
  <xsl:value-of select="substring('                               ',string-length(@name)+1)"/>
  <xsl:text xml:space="preserve">= </xsl:text><xsl:value-of select="@value"/><xsl:text>;</xsl:text>     
</xsl:template>

<xsl:template match="attribute" mode="IDLInterfaces">
  <xsl:value-of select="$IDLindent2"/>
  <xsl:choose>
    <xsl:when test="normalize-space(@readonly)='yes'"><xsl:text xml:space="preserve">readonly </xsl:text></xsl:when>
    <xsl:otherwise><xsl:text xml:space="preserve">         </xsl:text></xsl:otherwise>
  </xsl:choose>
  <xsl:text xml:space="preserve">attribute </xsl:text>
  <xsl:value-of select="@type"/>
  <xsl:value-of select="substring('                 ',string-length(@type)+1)"/>
  <xsl:text xml:space="preserve"> </xsl:text><xsl:value-of select="@name"/><xsl:text>;</xsl:text>
  <xsl:apply-templates select="raises|setraises|getraises" mode="IDLInterfaces"/>
</xsl:template>

<xsl:template match="method" mode="IDLInterfaces">
  <xsl:value-of select="$IDLindent2"/>
  <xsl:value-of select="returns/@type"/>
  <xsl:value-of select="substring('                         ',string-length(returns/@type)+1)"/>
  <xsl:text xml:space="preserve"> </xsl:text>
  <xsl:value-of select="@name"/><xsl:text>(</xsl:text>
  <xsl:apply-templates select="parameters" mode="IDLInterfaces"/>
  <xsl:text>)</xsl:text>
  <xsl:apply-templates select="raises" mode="IDLInterfaces"/>
  <xsl:text>;</xsl:text>
</xsl:template>

<xsl:template match="parameters" mode="IDLInterfaces">
  <xsl:variable name="localParent"><xsl:value-of select="ancestor::method/@name"/></xsl:variable>
  <xsl:variable name="localParamIndent"><xsl:value-of select="$IDLindent2"/>
    <xsl:text xml:space="preserve">                         </xsl:text>
    <xsl:value-of select="substring('                                                                                   ',1,string-length($localParent)+2)"/>
  </xsl:variable>
  <xsl:for-each select="param[not(@diff='del')]">
    <xsl:if test="count(preceding-sibling::param)>0">
      <xsl:text>,</xsl:text>
      <xsl:value-of select="$localParamIndent"/>
    </xsl:if>
    <xsl:value-of select="./@attr"/><xsl:text xml:space="preserve"> </xsl:text>
    <xsl:value-of select="./@type"/><xsl:text xml:space="preserve"> </xsl:text>
    <xsl:value-of select="./@name"/>
  </xsl:for-each>
</xsl:template>

<xsl:template match="raises" mode="IDLInterfaces">
  <xsl:if test="count(exception)>0">
    <xsl:value-of select="$raisesIndent"/><xsl:text xml:space="preserve">raises(</xsl:text>
    <xsl:for-each select="exception">
      <xsl:variable name="localExceptionName" select="@name"/>
      <xsl:if test="count(preceding-sibling::exception[normalize-space(@name)=$localExceptionName])=0">
        <xsl:if test="count(preceding-sibling::exception[not(normalize-space(@name)=$localExceptionName)])!=0">
          <xsl:text>,</xsl:text>
          <xsl:value-of select="$raisesIndent"/>
        </xsl:if>
        <xsl:value-of select="$localExceptionName"/>
      </xsl:if>
    </xsl:for-each>
    <xsl:text>)</xsl:text>
  </xsl:if>
</xsl:template>

<xsl:template match="setraises" mode="IDLInterfaces">
  <xsl:for-each select="exception">
    <xsl:variable name="localExceptionName" select="@name"/>
    <xsl:if test="count(preceding-sibling::exception[normalize-space(@name)=$localExceptionName])=0">
      <xsl:value-of select="$raisesIndent"/><xsl:text xml:space="preserve">// raises(</xsl:text>
      <xsl:value-of select="$localExceptionName"/><xsl:text xml:space="preserve">) on setting</xsl:text>
    </xsl:if>
  </xsl:for-each>
</xsl:template>

<xsl:template match="getraises" mode="IDLInterfaces">
  <xsl:for-each select="exception">
    <xsl:variable name="localExceptionName" select="@name"/>
    <xsl:if test="count(preceding-sibling::exception[normalize-space(@name)=$localExceptionName])=0">
      <xsl:value-of select="$raisesIndent"/><xsl:text xml:space="preserve">// raises(</xsl:text>
      <xsl:value-of select="$localExceptionName"/><xsl:text xml:space="preserve">) on retrieval</xsl:text>
    </xsl:if>
  </xsl:for-each>
</xsl:template>

<xsl:template match="text()" mode="IDLInterfaces">
</xsl:template>

<xsl:template match="*" mode="IDLInterfaces">
  <xsl:apply-templates mode="IDLInterfaces"/>
</xsl:template>

<!-- Java Binding -->

<xsl:template match="div1[@id='mathml-dom']" mode="javaInterfaces">
  <xsl:apply-templates mode="javaInterfaces" select=".//interface"/>
</xsl:template>

<!-- JavaFileHeader -->

<xsl:template name="javaFileHeader">
  <xsl:value-of select="$javaPackageDeclaration"/>
  <xsl:for-each select=".//attribute/@type|.//param/@type|.//returns/@type|@inherits|.//exception/@name">
    <xsl:apply-templates mode="javaGetExternalDeclarations" select="."/>
  </xsl:for-each>
</xsl:template>

<xsl:template mode="javaGetExternalDeclarations" match="text()">
</xsl:template>

<xsl:template mode="javaGetExternalDeclarations" match="@*">
  <xsl:variable name="targetType" select="normalize-space(.)"/>
  <xsl:if test="not(starts-with($targetType,'MathML') or $targetType='void' or $targetType='long' or $targetType='unsigned long' or $targetType='short' or $targetType='unsigned short' or $targetType='DOMString' or $targetType='boolean')">
    <xsl:variable name="localInterfaceParent" select="normalize-space(ancestor::interface/@name)"/>
    <xsl:variable name="firstCount" select="count(ancestor-or-self::*[ancestor::interface[normalize-space(@name)=$localInterfaceParent]]/preceding-sibling::*/descendant-or-self::*[self::attribute|self::returns|self::constant|self::param][normalize-space(@type)=$targetType])"/>
    <xsl:variable name="secondCount" select="count(ancestor-or-self::*[ancestor::interface[normalize-space(@name)=$localInterfaceParent]]/preceding-sibling::*/descendant-or-self::exception[normalize-space(@name)=$targetType])"/>
    <xsl:if test="not(normalize-space(ancestor::interface[@inherits])=$targetType) and $firstCount=0 and $secondCount=0">
      <xsl:call-template name="javaImportExternal">
        <xsl:with-param name="theSource">dom</xsl:with-param>
        <xsl:with-param name="theEntity" select="$targetType"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:if>
</xsl:template>

<xsl:template name="javaImportExternal">
  <xsl:param name="theSource"/>
  <xsl:param name="theEntity"/>
  <xsl:if test="normalize-space($theEntity) and normalize-space($theSource)">
    <xsl:text xml:space="preserve">
import org.w3c.</xsl:text><xsl:value-of select="$theSource"/>
    <xsl:text>.</xsl:text>
    <xsl:value-of select="$theEntity"/>
    <xsl:text>;</xsl:text>
  </xsl:if>
</xsl:template>

<!-- javaInterfaces Templates -->

<xsl:template match="interface" mode="javaInterfaces">
  <h3><a name="{generate-id()}" id="{generate-id()}"/>
  <xsl:text>org/w3c/dom/mathml/</xsl:text><xsl:value-of select="@name"/><xsl:text>.java</xsl:text>
  </h3>
  <div class="IDL-definition"><pre>
    <xsl:call-template name="javaFileHeader" />
    <xsl:value-of select="$IDLindent0"/>
    <xsl:value-of select="$IDLindent0"/>
    <xsl:text xml:space="preserve">public interface </xsl:text>
    <xsl:value-of select="@name"/>
    <xsl:if test="normalize-space(@inherits)">
      <xsl:text xml:space="preserve"> extends </xsl:text>
      <xsl:value-of select="@inherits"/>
    </xsl:if>
    <xsl:value-of select="$IDLindent0"/>
    <xsl:text>{</xsl:text>
    <xsl:apply-templates mode="javaInterfaces"/>
    <xsl:value-of select="$IDLindent0"/>
    <xsl:text xml:space="preserve">};
    </xsl:text>
  </pre></div>
</xsl:template>

<xsl:template name="javaTranslateTypeName">
  <xsl:param name="targetType" select="normalize-space(@type)"/>
  <xsl:choose>
    <xsl:when test="$targetType='DOMString'">
      <xsl:text>String</xsl:text>
    </xsl:when>
    <xsl:when test="$targetType='unsigned long' or $targetType='long'">
      <xsl:text>int</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$targetType"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="javaTranslateProcName">
  <xsl:param name="whichMode" select="get"/>
  <xsl:param name="attribName" select="normalize-space(@name)"/>
  <xsl:choose>
    <xsl:when test="$whichMode='set'">
      <xsl:text>set</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>get</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:value-of select="translate(substring($attribName,1,1),$lowerCaseString,$upperCaseString)"/>
  <xsl:value-of select="substring($attribName,2)"/>
</xsl:template>

<xsl:template match="constant" mode="javaInterfaces">
  <xsl:value-of select="$IDLindent2"/><xsl:text xml:space="preserve">public static final </xsl:text>
  <xsl:variable name="javaTypeName">
    <xsl:call-template name="javaTranslateTypeName">
      <xsl:with-param name="targetType" select="@type"/>
    </xsl:call-template>
  </xsl:variable>
  <xsl:value-of select="$javaTypeName"/>
  <xsl:value-of select="substring('                      ',string-length($javaTypeName)+1)"/>
  <xsl:value-of select="@name"/>
  <xsl:value-of select="substring('                          ',string-length(@name)+1)"/>
  <xsl:text xml:space="preserve">= </xsl:text><xsl:value-of select="@value"/><xsl:text>;</xsl:text>     
</xsl:template>

<xsl:template match="attribute" mode="javaInterfaces">
  <xsl:value-of select="$IDLindent2"/><xsl:text xml:space="preserve">public </xsl:text>
  <xsl:variable name="javaTypeName">
    <xsl:call-template name="javaTranslateTypeName">
      <xsl:with-param name="targetType" select="@type"/>
    </xsl:call-template>
  </xsl:variable>
  <xsl:value-of select="$javaTypeName"/>
  <xsl:value-of select="substring('                      ',string-length($javaTypeName)+1)"/>
  <xsl:text xml:space="preserve"> </xsl:text>
  <xsl:call-template name="javaTranslateProcName">
    <xsl:with-param name="attribName" select="@name"/>
    <xsl:with-param name="whichMode" select="get"/>
  </xsl:call-template>
  <xsl:text>()</xsl:text>
  <xsl:for-each select="getraises">
    <xsl:apply-templates select="."/>
  </xsl:for-each>
  <xsl:text>;</xsl:text>
  <xsl:if test="not(normalize-space(@readonly)='yes')">
    <xsl:value-of select="$IDLindent2"/><xsl:text>public void</xsl:text>
    <xsl:value-of select="substring('                      ',string-length('void')+1)"/>
    <xsl:text xml:space="preserve"> </xsl:text>
    <xsl:call-template name="javaTranslateProcName">
      <xsl:with-param name="attribName" select="@name"/>
      <xsl:with-param name="whichMode">set</xsl:with-param>
    </xsl:call-template>
    <xsl:text>(</xsl:text>
    <xsl:value-of select="$javaTypeName"/>
    <xsl:text xml:space="preserve"> </xsl:text><xsl:value-of select="normalize-space(@name)"/>
    <xsl:text>)</xsl:text>
    <xsl:for-each select="setraises">
      <xsl:apply-templates select="." mode="javaInterfaces"/>
    </xsl:for-each>
    <xsl:text>;</xsl:text>
  </xsl:if>
</xsl:template>

<xsl:template match="setraises|getraises|raises" mode="javaInterfaces">
  <xsl:if test="count(exception[normalize-space(@name)])">
    <xsl:value-of select="$javaRaisesIndent"/><xsl:text xml:space="preserve">throws </xsl:text>
    <xsl:for-each select="exception">
      <xsl:variable name="localExceptionName" select="normalize-space(@name)"/>
      <xsl:if test="$localExceptionName and not(preceding-sibling::exception[normalize-space(@name)=$localExceptionName])">
        <xsl:if test="preceding-sibling::exception[not(normalize-space(@name)=$localExceptionName)]">
          <xsl:text>,</xsl:text>
        </xsl:if>
        <xsl:value-of select="$localExceptionName"/>
      </xsl:if>
    </xsl:for-each>
  </xsl:if>
</xsl:template>

<xsl:template match="method" mode="javaInterfaces">
  <xsl:value-of select="$IDLindent2"/><xsl:text xml:space="preserve">public </xsl:text>
  <xsl:variable name="javaTypeName">
    <xsl:call-template name="javaTranslateTypeName">
      <xsl:with-param name="targetType" select="returns/@type"/>
    </xsl:call-template>
  </xsl:variable>
  <xsl:value-of select="$javaTypeName"/>
  <xsl:value-of select="substring('                      ',string-length($javaTypeName)+1)"/>
  <xsl:text xml:space="preserve"> </xsl:text><xsl:value-of select="@name"/><xsl:text>(</xsl:text>
  <xsl:apply-templates select="parameters" mode="javaInterfaces"/>
  <xsl:text>)</xsl:text>
  <xsl:apply-templates select="raises" mode="javaInterfaces"/>
  <xsl:text>;</xsl:text>
</xsl:template>

<xsl:template match="parameters" mode="javaInterfaces">
  <xsl:variable name="localParent"><xsl:value-of select="parent::method/@name"/></xsl:variable>
  <xsl:variable name="localParamIndent"><xsl:value-of select="$IDLindent2"/>
    <xsl:text xml:space="preserve">                      </xsl:text>
    <xsl:value-of select="substring('                                                                                   ',1,string-length($localParent) + string-length('public ( '))"/>
  </xsl:variable>
  <xsl:for-each select="param[not(@diff='del')]">
    <xsl:if test="count(preceding-sibling::param)>0">
      <xsl:text>,</xsl:text>
      <xsl:value-of select="$localParamIndent"/>
    </xsl:if>
    <xsl:call-template name="javaTranslateTypeName"/>
    <xsl:text xml:space="preserve"> </xsl:text>
    <xsl:value-of select="./@name"/>
  </xsl:for-each>
</xsl:template>

<xsl:template match="text()" mode="javaInterfaces">
</xsl:template>

<xsl:template match="*" mode="javaInterfaces">
<!--   <xsl:apply-templates mode="javaInterfaces"/> -->
</xsl:template>


<!-- ECMAScript Binding -->

<xsl:template match="div1[@id='mathml-dom']" mode="ecmaInterfaces">
  <div class="IDL-definition">
  <xsl:apply-templates mode="ecmaInterfaces" select=".//interface"/>
  </div>
</xsl:template>

<xsl:template match="interface" mode="ecmaInterfaces">
  <xsl:if test="count(constant) > 0">
    <dl>
    <dt class="h3style"><!--<h3>--><strong> 
    <xsl:text xml:space="preserve">Class </xsl:text>
    <xsl:value-of select="@name"/>
    </strong><!--</h3>--></dt>
    <dd><xsl:text xml:space="preserve">The </xsl:text>
    <strong><xsl:value-of select="@name"/></strong>
    <xsl:text xml:space="preserve"> class has the following constants:</xsl:text>
    <dl>
    <xsl:apply-templates select="constant" mode="ecmaInterfaces"/>
    </dl></dd>
    </dl>
  </xsl:if>
  <dl><dt class="h3style">
  <xsl:text xml:space="preserve">Object </xsl:text>
  <xsl:value-of select="@name"/>
  </dt>
  <xsl:if test="normalize-space(@inherits)">
    <dd>
    <strong>
    <xsl:value-of select="@name"/></strong>
    <xsl:text xml:space="preserve"> has all the properties and methods of </xsl:text>
    <strong><xsl:value-of select="@inherits"/></strong>
    <xsl:text xml:space="preserve"> as well as the properties and methods defined below.</xsl:text>
    </dd>
  </xsl:if>
  <xsl:if test="count(attribute) > 0">
    <dd>
    <dl><dt>
    <xsl:text xml:space="preserve">The </xsl:text>
    <strong><xsl:value-of select="@name"/></strong>
    <xsl:text xml:space="preserve"> object has the following properties:</xsl:text></dt>
    <xsl:apply-templates select="attribute" mode="ecmaInterfaces"/>
    </dl>
    </dd>
  </xsl:if>
  <xsl:if test="count(method) > 0">
    <dd>
    <dl><dt>
    <xsl:text xml:space="preserve">The </xsl:text>
    <strong><xsl:value-of select="@name"/></strong>
    <xsl:text xml:space="preserve"> object has the following methods:</xsl:text>
    </dt>
    <xsl:apply-templates select="method" mode="ecmaInterfaces"/>
    </dl>
    </dd>
  </xsl:if>
  </dl>
</xsl:template>

<xsl:template match="constant" mode="ecmaInterfaces">
  <dd>
  <dl><dt>
  <strong><xsl:value-of select="parent::interface/@name"/>
  <xsl:text>.</xsl:text>
  <xsl:value-of select="@name"/></strong></dt>
  <dd>
  <xsl:text xml:space="preserve">This constant is of type </xsl:text>
  <xsl:value-of select="@type"/>
  <xsl:text xml:space="preserve"> and its value is </xsl:text>
  <xsl:value-of select="@value"/>
  <xsl:text>.</xsl:text>
  </dd>
  </dl>
  </dd>
</xsl:template>

<xsl:template match="attribute" mode="ecmaInterfaces">
   <xsl:if test="not(@diff='del' and $show.diff.markup='0')">
  <dd>
        <xsl:if test="@diff and $show.diff.markup='1'">
          <xsl:attribute name="class">
            <xsl:text>diff-</xsl:text>
            <xsl:value-of select="@diff"/>
          </xsl:attribute>
        </xsl:if>
  <dl><dt>
  <strong><xsl:value-of select="@name"/></strong></dt>
  <dd>
  <xsl:text xml:space="preserve">This property is of type </xsl:text>
  <strong><xsl:value-of select="@type"/></strong>
  <xsl:text>.</xsl:text>
  </dd>
  </dl></dd>
</xsl:if>
</xsl:template>

<xsl:template match="method" mode="ecmaInterfaces">
  <dd>
  <dl><dt>
  <strong><xsl:value-of select="@name"/><xsl:text>(</xsl:text>
  <xsl:for-each select="parameters/param">
    <xsl:if test="count(preceding-sibling::param) > 0">
      <xsl:text>,</xsl:text>
    </xsl:if>
    <xsl:value-of select="@name"/>
  </xsl:for-each>
  <xsl:text>)</xsl:text></strong>
  </dt>
  <dd>
  <xsl:variable name="returnType" select="normalize-space(returns/@type)"/>
  <xsl:choose>
    <xsl:when test="not($returnType)">
      <xsl:text xml:space="preserve">This method returns a </xsl:text>
      <strong><xsl:text>void</xsl:text></strong>
    </xsl:when>
    <xsl:when test="contains('aeiou',substring($returnType,1,1))">
      <xsl:text xml:space="preserve">This method returns an </xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text xml:space="preserve">This method returns a </xsl:text>
    </xsl:otherwise>
  </xsl:choose>
  <strong><xsl:value-of select="$returnType"/><xsl:text>.</xsl:text></strong>
  <xsl:apply-templates select="parameters" mode="ecmaInterfaces"/>
  </dd></dl>
  </dd>
</xsl:template>

<xsl:template match="parameters" mode="ecmaInterfaces">
  <xsl:for-each select="param">
    <xsl:text xml:space="preserve"> The </xsl:text>
    <strong><xsl:value-of select="./@name"/></strong>
    <xsl:text xml:space="preserve"> parameter is of type </xsl:text>
    <strong><xsl:value-of select="./@type"/></strong><xsl:text>.</xsl:text>
  </xsl:for-each>
</xsl:template>

<xsl:template match="raises|setraises|getraises" mode="ecmaInterfaces">
</xsl:template>

<xsl:template match="text()" mode="ecmaInterfaces">
</xsl:template>

<xsl:template match="*" mode="ecmaInterfaces">
  <xsl:apply-templates mode="ecmaInterfaces"/>
</xsl:template>

<!-- Generating DOM Inheritance Chart -->
<xsl:template match="interface" mode="showInheritance">
  <xsl:variable name="thisName" select="normalize-space(@name)"/>
  <dd>
  <xsl:variable name="theReference">
    <xsl:choose> 
    <xsl:when test="starts-with($thisName,'MathML')">
      <a>
      <xsl:attribute name="href">
	    <xsl:if test="ancestor::div1|inform-div1[not(@id='mathml-dom')]">
		  <xsl:value-of select="id('mathml-dom')/@role"/>
                  <xsl:value-of select="$filename.extension"/>
            </xsl:if>
		<xsl:text>#dom.</xsl:text>
        <xsl:value-of select="substring-after($thisName,'MathML')"/>
      </xsl:attribute>
      <xsl:value-of select="$thisName"/>
      </a>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$thisName"/>
    </xsl:otherwise>
    </xsl:choose>
	<xsl:if test="contains(@inherits,',')">
      <xsl:text xml:space="preserve"> [also inherits from: </xsl:text>
      <xsl:call-template name="dom-type-inherits">
        <xsl:with-param name="typestring" select="normalize-space(substring-after(@inherits,','))" />
	  </xsl:call-template>
	  <xsl:text>]</xsl:text>
	</xsl:if>
  </xsl:variable>
  <xsl:choose>
  <xsl:when test="count(ancestor::div1//interface[normalize-space(@inherits)=$thisName or (contains(normalize-space(@inherits),',') and substring-before(normalize-space(@inherits),',')=$thisName)]) > 0">
    <dl><dt><xsl:text>---</xsl:text>
<!--     <xsl:call-template name="dom-type"> -->
<!--       <xsl:with-param name="type" select="$thisName"/> -->
<!--     </xsl:call-template> -->
    <xsl:copy-of select="$theReference"/>
    </dt>
      <xsl:apply-templates select="ancestor::div1//interface[normalize-space(@inherits)=$thisName or (contains(normalize-space(@inherits),',') and substring-before(normalize-space(@inherits),',')=$thisName)]" mode="showInheritance"/>
    </dl>
  </xsl:when>
  <xsl:otherwise>
    <xsl:text>---</xsl:text>
    <xsl:copy-of select="$theReference"/>
<!--     <xsl:call-template name="dom-type"> -->
<!--       <xsl:with-param name="type" select="$thisName"/> -->
<!--     </xsl:call-template> -->
  </xsl:otherwise>
  </xsl:choose>
  </dd>
</xsl:template>

<xsl:template match="*" mode="showInheritance">
</xsl:template>

<xsl:template match="text()" mode="showInheritance">
</xsl:template>


<!-- appendix c -->

  <xsl:template mode="divnum" match="MMLdefinition">
    <xsl:number level="multiple"
      count="div1 | div2 | div3 | div4 | MMLdefinition |inform-div1"
      format="A.1.1.1 "/>
  </xsl:template>

<xsl:template match="MMLdefinition">
  <xsl:element name="h{5 -$slice.depth}">
     <xsl:call-template name="anchor"/>
      <xsl:number level="multiple" count="inform-div1|div1|div2|div3|div4|MMLdefinition" format="A.1.1.1 "/>
  MMLdefinition: <code><xsl:value-of select="name"/></code>
  </xsl:element>
   <dl>
  <xsl:apply-templates select="description"/>

  <xsl:apply-templates select="classification"/>

  <xsl:if test="MMLattribute">
  <dt>MMLattribute</dt>
  <dd><table border="1">
  <tr><th>Name</th><th>Value</th><th>Default</th></tr>
  <xsl:for-each select="MMLattribute">
  <tr><xsl:apply-templates/></tr>
  </xsl:for-each>
  </table>
  </dd>
  </xsl:if>

  <xsl:if test="signature">
  <dt>Signature</dt>
  <dd>
  <xsl:apply-templates select="signature"/>
  </dd>
  </xsl:if>


  <xsl:apply-templates select="property|MMLexample"/>

  </dl>

</xsl:template>

<xsl:template match="signature">
    <p><xsl:value-of select="."/></p>
</xsl:template>


<xsl:template match="MMLexample">
<dt>Example</dt>
<dd><xsl:apply-templates select="description"/><pre>
        <xsl:if test="@diff and $show.diff.markup='1'">
          <xsl:attribute name="class">
            <xsl:text>diff-</xsl:text>
            <xsl:value-of select="@diff"/>
          </xsl:attribute>
        </xsl:if>
<xsl:apply-templates select="node()[not(self::description)]"/>
</pre></dd>
</xsl:template>

<xsl:template match="classification">
<dt>Classification</dt>
<dd><xsl:apply-templates/></dd>
</xsl:template>


<xsl:template match="attvalue|attname|attdefault">
<td><xsl:apply-templates/></td>
</xsl:template>


<xsl:template match="property">
<dt>Property</dt>
<dd>
<xsl:apply-templates select="description"/>
<pre>
        <xsl:if test="@diff and $show.diff.markup='1'">
          <xsl:attribute name="class">
            <xsl:text>diff-</xsl:text>
            <xsl:value-of select="@diff"/>
          </xsl:attribute>
        </xsl:if>
<xsl:apply-templates select="node()[not(self::description)]"/>
</pre></dd>
</xsl:template>

<xsl:template match="description">
<xsl:apply-templates/>
</xsl:template>


<xsl:template match="MMLdefinition/name"/>


<xsl:template match="MMLdefinition/functorclass"/>



<xsl:template match="MMLdefinition/description">
<dt>Description</dt>
<dd><xsl:apply-templates/>
   <p>See also
   <xsl:variable name="x" 
     select="id(concat('contm_',normalize-space(preceding-sibling::name)))"/>
   <xsl:choose>
   <xsl:when test="$x">
   <xsl:for-each select="$x">
  <a>
          <xsl:attribute name="href">
            <xsl:call-template name="href.target">
              <xsl:with-param name="target" select="."/>
            </xsl:call-template>
          </xsl:attribute>
          <b>
            <xsl:apply-templates select="." mode="divnum"/>
            <xsl:apply-templates select="head" mode="text"/>
          </b>
        </a>
   </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
   <xsl:for-each select="id('contm_trig')">
  <a>
          <xsl:attribute name="href">
            <xsl:call-template name="href.target">
              <xsl:with-param name="target" select="."/>
            </xsl:call-template>
          </xsl:attribute>
          <b>
            <xsl:apply-templates select="." mode="divnum"/>
            <xsl:apply-templates select="head" mode="text"/>
          </b>
        </a>
   </xsl:for-each>
   </xsl:otherwise>
   </xsl:choose>.</p>
</dd>
</xsl:template>


<!--
MathML Customistations

templates below this point are handle specific features or stylistic
requirements of the MathMl specification.
-->


<!-- handle both authors and editors (marked up in the same authlist,
but distinguished by role="editor" attribute -->
<!-- as requested by Patrick, list editors twice, as they are also authors -->

<xsl:template match="authlist">
  <dt>
  <xsl:text>Editor</xsl:text>
  <xsl:if test="count(author[@role='editor']) > 1">s</xsl:if>:<xsl:text/>
  </dt>
  <xsl:apply-templates mode= "editor" select="author[@role='editor']"/>
  <xsl:if test="author[not(@role='@editor')]">
  <dt>
  <xsl:text>Principal Authors:</xsl:text>
  </dt>
  <!--<dd><xsl:apply-templates select="author[not(@role='editor')]"/></dd>-->
  <dd><xsl:apply-templates select="author"/></dd>
  </xsl:if>
</xsl:template>

<xsl:template  mode= "editor" match="author[@role='editor']">
  <dd><xsl:apply-templates/></dd>
</xsl:template>

<xsl:template match="author">
  <xsl:value-of select="name"/>
  <xsl:if test="position() != last()">, </xsl:if>
</xsl:template>

  <xsl:template match="author[@diff]" priority="1">
    <xsl:choose>
      <xsl:when test="@diff and $show.diff.markup='1'">
	  <span class="diff-{ancestor-or-self::*/@diff}">
	      <xsl:value-of select="name"/>
  <xsl:if test="position() != last()">, </xsl:if>
	  </span>
      </xsl:when>
      <xsl:when test="@diff='del' and $show.diff.markup='0'">
	<!-- suppressed -->
      </xsl:when>
      <xsl:otherwise>
	    <xsl:value-of select="name"/>
  <xsl:if test="position() != last()">, </xsl:if>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <xsl:template match="latestloc[@role='rec']">
    <dt>Latest MathML Recommendation:</dt>
    <dd>
      <xsl:apply-templates/>
    </dd>
  </xsl:template>

  <xsl:template match="latestloc">
    <dt>Latest MathML 2 version:</dt>
    <dd>
      <xsl:apply-templates/>
    </dd>
  </xsl:template>

<!-- errata linking -->
<!-- add the apply-templates errataloc here rather than  the main
header template as it's smaller... -->

  <xsl:template match="altlocs">
    <xsl:apply-templates select="../errataloc"/>
    <p>
      <xsl:text>In addition to the </xsl:text>
       <a href="overview.html">HTML</a>
      <xsl:text> version, </xsl:text>
      <xsl:text>this document is also available </xsl:text>
      <xsl:text>in these non-normative formats: </xsl:text>
      <xsl:for-each select="loc">
        <xsl:if test="position() &gt; 1">
          <xsl:if test="last() &gt; 2">
            <xsl:text>, </xsl:text>
          </xsl:if>
          <xsl:if test="last() = 2">
            <xsl:text> </xsl:text>
          </xsl:if>
        </xsl:if>
        <xsl:if test="position() = last() and position() &gt; 1">and&#160;</xsl:if>
        <a href="{@href}"><xsl:apply-templates/></a>
      </xsl:for-each>
      <xsl:text>.</xsl:text>
    </p>
    <xsl:apply-templates select="../translationloc"/>
  </xsl:template>



  <xsl:template match="errataloc">
  <p>Please refer to the <a href="{loc/@href}"><strong>errata</strong></a>
for this document, which may include some normative corrections.</p>
  </xsl:template>

  <xsl:template match="translationloc">
  <p>See also <a href="{loc/@href}"><strong>translations</strong></a>.</p>
  </xsl:template>

<!-- convert tr in table head to th -->
<xsl:template match="thead/tr/td">
  <th>
  <xsl:copy-of select="@bgcolor|@rowspan|@colspan|@align|@valign"/>
  <xsl:choose>
    <xsl:when test="normalize-space(.)=''">&#160;</xsl:when>
    <xsl:otherwise>
      <xsl:apply-templates/>
    </xsl:otherwise>
  </xsl:choose>
  </th>
</xsl:template>

<!-- zap _ in ids -->
  <xsl:template match="table">
    <table>
        <!-- Wait: some of these aren't HTML attributes after all... -->
        <xsl:copy-of select="@*[local-name(.) != 'diff']"/>
        <xsl:if test="@id">
         <xsl:attribute name="id"><xsl:value-of
  select="translate(@id,'_','.')"/></xsl:attribute>
        </xsl:if>
      <xsl:apply-templates/>

      <xsl:if test=".//footnote">
        <tbody>
          <tr>
            <td>
              <xsl:apply-templates select=".//footnote" mode="table.notes"/>
            </td>
          </tr>
        </tbody>
      </xsl:if>
    </table>
  </xsl:template>


<!-- restore the navigation bars to more like the old style -->


<xsl:template name="navigation.top">
  <xsl:param name="prev" select="''"/>
  <xsl:param name="next" select="''"/>

  <xsl:comment> TOP NAVIGATION BAR </xsl:comment>
  <div class="minitoc">

  Overview: <a href="{$front.filename.base}{$filename.extension}"><xsl:value-of select="/spec/header/title"/></a><br/>
  <xsl:if test="$prev">
  Previous: <xsl:apply-templates mode="divnum" select="$prev"/>
            <a>
              <xsl:attribute name="href">
                <xsl:call-template name="href.target">
                  <xsl:with-param name="target" select="$prev"/>
                </xsl:call-template>
              </xsl:attribute>
              <xsl:apply-templates select="$prev/head/node()"/>
            </a>
    <br/>
  </xsl:if>
 <xsl:if test="$next">
  Next: <xsl:apply-templates mode="divnum" select="$next"/>
            <a>
              <xsl:attribute name="href">
                <xsl:call-template name="href.target">
                  <xsl:with-param name="target" select="$next"/>
                </xsl:call-template>
              </xsl:attribute>
              <xsl:apply-templates select="$next/head/node()"/>
            </a>
   <br/>
  </xsl:if>
   <br/>
        <xsl:apply-templates mode="toc" select=".">
          <xsl:with-param name="just.filename" select="'0'"/>
          <xsl:with-param name="toc.level" select="4"/>
        </xsl:apply-templates>
</div>
</xsl:template>


<xsl:template name="navigation.bottom">
  <xsl:param name="prev" select="''"/>
  <xsl:param name="next" select="''"/>

  <div class="minitoc">

  Overview: <a href="{$front.filename.base}{$filename.extension}"><xsl:value-of select="/spec/header/title"/></a><br/>
  <xsl:for-each select="$prev">
  Previous:     <xsl:choose>
      <xsl:when test="ancestor::body">
        <xsl:number format="1.1 " level="multiple" count="div1|div2|div3|div4|div5"/>
      </xsl:when>
      <xsl:when test="ancestor::back">
        <xsl:number format="A.1 " level="multiple" count="div1|inform-div1|div2|div3|div4|div5"/>
      </xsl:when>
    </xsl:choose>
            <a>
              <xsl:attribute name="href">
                <xsl:call-template name="href.target">
                  <xsl:with-param name="target" select="."/>
                  <xsl:with-param name="just.filename" select="1"/>
                </xsl:call-template>
              </xsl:attribute>
              <xsl:apply-templates select="head/node()"/>
            </a>
    <br/>
  </xsl:for-each>
 <xsl:for-each select="$next">
  Next:     <xsl:choose>
      <xsl:when test="ancestor::body">
        <xsl:number format="1.1 " level="multiple" count="div1|div2|div3|div4|div5"/>
      </xsl:when>
      <xsl:when test="ancestor::back">
        <xsl:number format="A.1 " level="multiple" count="div1|inform-div1|div2|div3|div4|div5"/>
      </xsl:when>
    </xsl:choose>

            <a>
              <xsl:attribute name="href">
                <xsl:call-template name="href.target">
                  <xsl:with-param name="target" select="."/>
                  <xsl:with-param name="just.filename" select="1"/>
                </xsl:call-template>
              </xsl:attribute>
              <xsl:apply-templates select="head/node()"/>
            </a>
 </xsl:for-each>
</div>
</xsl:template>

<!-- eg roles -->

<xsl:template match="eg">
  <xsl:choose>
    <xsl:when test="@role">
      <xsl:choose>
        <xsl:when test="@role='mathml-error'">
          <pre class='error'>
          <xsl:apply-templates/>
          </pre>
        </xsl:when>
        <xsl:when test="@role='text'">
          <blockquote>
          <p><xsl:apply-templates/></p>
          </blockquote>
        </xsl:when>
        <xsl:otherwise>
          <pre>
          <xsl:apply-templates/>
          </pre>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    <xsl:otherwise>
      <pre>
      <xsl:apply-templates/>
      </pre>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- kw role -->

<xsl:template match="kw">
  <xsl:choose>
    <xsl:when test="@role">
      <xsl:choose>
        <xsl:when test="@role='entity'">
          <code>&amp;<xsl:apply-templates/>;</code>
        </xsl:when>
        <xsl:otherwise>
           <xsl:message>unkown role <xsl:value-of select="@role"/> on kw</xsl:message>
          <code class="error"><xsl:apply-templates/></code>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    <xsl:otherwise>
      <b><xsl:apply-templates/></b>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


  <xsl:template match="el">
  <xsl:choose>
    <xsl:when test="@role">
      <xsl:choose>
        <xsl:when test="@role='starttag'">
          <code>&lt;<xsl:apply-templates/>&gt;</code>
        </xsl:when>
        <xsl:when test="@role='endtag'">
          <code>&lt;/<xsl:apply-templates/>&gt;</code>
        </xsl:when>
        <xsl:when test="@role='emptytag'">
          <code>&lt;<xsl:apply-templates/>/&gt;</code>
        </xsl:when>
        <xsl:otherwise>
           <xsl:message>unkown role <xsl:value-of select="@role"/> on el</xsl:message>
          <code class="error"><xsl:apply-templates/></code>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    <xsl:otherwise>
    <code><xsl:apply-templates/></code>
    </xsl:otherwise>
  </xsl:choose>
  </xsl:template>

<xsl:template match="tr[@diff]|td[@diff]" priority="662">
<xsl:if test="not(@diff='del' and $show.diff.markup='0')">
<xsl:element name="{local-name()}">
<xsl:copy-of select="@*[local-name(.) != 'diff']"/>
 <xsl:if test="$show.diff.markup='1'">
  <xsl:attribute name="class">diff-<xsl:value-of select="@diff"/></xsl:attribute>
 </xsl:if>
<xsl:apply-templates/>
</xsl:element>
</xsl:if>
</xsl:template>

<!-- don't put [Definition ... ] around termdef elements-->
<xsl:template match="termdef">
  <a name="{@id}" id="{@id}"></a>
  <xsl:apply-templates/>
</xsl:template>


<!-- anchor phrases if they have an id (used in appendix a) -->
  <xsl:template match="phrase">
    <xsl:call-template name="anchor"/>
    <xsl:apply-templates/>
  </xsl:template>

<!-- mathml CSS -->

<xsl:variable  name="additional.css">
  .error { color: red }
  .minitoc { border-style: solid;
             border-color: #0050B2; 
             border-width: 1px ;
             padding: 0.3em; }
  .attention { border-style: solid; 
               border-width: 1px ; 
               color: #5D0091;
               background: #F9F5DE; 
               border-color: red;
               margin-left: 1em;
               margin-right: 1em;
               margin-top: 0.25em;
               margin-bottom: 0.25em; }

  .attribute-Name { background: #F9F5C0; }
  .method-Name { background: #C0C0F9; }
  .IDL-definition { border-style: solid; 
               border-width: 1px ; 
               color: #001000;
               background: #E0FFE0; 
               border-color: #206020;
               margin-left: 1em;
               margin-right: 1em;
               margin-top: 0.25em;
               margin-bottom: 0.25em; }
  .baseline {vertical-align: baseline}

  #eqnoc1 {width: 10%}
  #eqnoc2 {width: 80%; text-align: center; }
  #eqnoc3 {width: 10%; text-align: right; }

div.div1 {margin-bottom: 1em;}
          
.h3style {
  text-align: left;
  font-family: sans-serif;
  font-weight: normal;
  color: #0050B2; 
  font-size: 125%;
}

  h4 { text-align: left;
       font-family: sans-serif;
       font-weight: normal;
       color: #0050B2; }
  h5 { text-align: left;
       font-family: sans-serif;
       font-weight: bold;
       color: #0050B2; } 

  th {background:  #E0FFE0;}

  p, blockquote, h4 { font-family: sans-serif; }
  dt, dd, dl, ul, li { font-family: sans-serif; }
  pre, code { font-family: monospace }


td.mathml-render {
font-family: serif;
font-size: 130%;
border: solid 4px green;
padding-left: 1em;
padding-right: 1em;
}

</xsl:variable>

<xsl:template match="blist">
  <dl>
  <xsl:apply-templates>
    <xsl:sort select="@id"/>
  </xsl:apply-templates>
  </dl>
</xsl:template>

</xsl:stylesheet>
